const context = cast.framework.CastReceiverContext.getInstance();
const playerManager = context.getPlayerManager();
const playbackConfig = new cast.framework.PlaybackConfig();

// Debug Logger
const castDebugLogger = cast.debug.CastDebugLogger.getInstance();
const LOG_TAG = 'AxinomDRM.LOG';

// Enable debug logger and show a 'DEBUG MODE' overlay at top left corner.
castDebugLogger.setEnabled(true);

// Show debug overlay on the TV screen.
// castDebugLogger.showDebugLogs(true);

// Set verbosity level for Core events.
castDebugLogger.loggerLevelByEvents = {
  'cast.framework.events.category.CORE': cast.framework.LoggerLevel.INFO,
  'cast.framework.events.EventType.MEDIA_STATUS': cast.framework.LoggerLevel.DEBUG
}

// Set verbosity level for custom tags.
castDebugLogger.loggerLevelByTags = {
    LOG_TAG: cast.framework.LoggerLevel.DEBUG,
};

let token = '';

function getDrmSystem(drmSystem){
   if(drmSystem == "PLAYREADY"){
    return cast.framework.ContentProtection.PLAYREADY;
  }
  else{
    return cast.framework.ContentProtection.PLAYREADY;
  }
}

// License request handler to set the X-AxDRM-Message token.
function licenseRequestHandler(networkRequestInfo) {
  castDebugLogger.info(LOG_TAG, 'DRM Content detected.');
  
  castDebugLogger.info(LOG_TAG, 'Setting X-AxDRM-Message header.');

  networkRequestInfo.headers = {
      'X-AxDRM-Message': token
  }

  return networkRequestInfo;
};

function mediaPlaybackInfoHandler(loadRequest, playbackConfig) {

  castDebugLogger.debug(LOG_TAG, 'Media PlaybackInfo Handler');

  if(loadRequest.media.customData?.token){
    castDebugLogger.info(LOG_TAG, 'Setting authentication token.');
    token = loadRequest.media.customData.token;
  }

  if(loadRequest.media.customData?.licenseUrl){
    castDebugLogger.info(LOG_TAG, 'Setting LS URL.');
    playbackConfig.licenseUrl = loadRequest.media.customData?.licenseUrl;
  }

  if(loadRequest.media.customData?.drmSystem){
    castDebugLogger.info(LOG_TAG, 'Setting DRM System.');
    playbackConfig.protectionSystem = getDrmSystem(loadRequest.media.customData?.drmSystem)
  }

  return playbackConfig;
}

// Set the license request handler to inject the authentication token.
playbackConfig.licenseRequestHandler = licenseRequestHandler;

// Set default license server URL and DRM System.
playbackConfig.licenseUrl = "https://drm-widevine-licensing.axtest.net/AcquireLicense";
playbackConfig.protectionSystem = cast.framework.ContentProtection.WIDEVINE;

playerManager.setMediaPlaybackInfoHandler(mediaPlaybackInfoHandler);

playerManager.setPlaybackConfig(playbackConfig);

context.start();